/* uncview.c -- Filter Recovering Contrl-Codes Visualized by "cview" */
/*  for UNIX  */
#include <stdio.h>

main(int argc, char *argv[])
{   int c;
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while ((c=getc(fp)) != EOF) {
        if (c < 0x20) continue;
        else if (c == '!') c = (getc(fp) | 0x80);
        else if (c == '\\') c = getc(fp);
        else if (c == '^') {
            c = getc(fp);
            if (c >= 0x60) c = ((c & 0x1f) | 0x80);
            else if (c >= '@') c = (c & 0x1f);
            else if (c == '?') c = 0x7f;
            else if (c == '#') c = 0x9f;
            else if (c == '$') c = 0xa0;
            else if (c == '/') c = 0xff;
        }
        putchar(c);
    }
    if (fp != stdin) fclose(fp);
}
