/* sj.c -- JIS/NEC/EUC to Shift-JIS Code Conversion Filter */
#include <stdio.h>
#define ESC 0x1b

main(int argc, char *argv[])
{   int c, c2, flag=0;
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while ((c=getc(fp)) != EOF) {
        if (c == ESC) {
            c = getc(fp);
            if (c == '(') {
                c2 = getc(fp);
                if ((c2=='H') || (c2=='J') || (c2=='@') || (c2=='B')) flag = 0;
                else { putchar(ESC); putchar(c); ungetc(c2,fp); }
            }
            else if (c == '$') {
                c2 = getc(fp);
                if ((c2=='@') || (c2=='B')) flag = 1;
                else if (c2 == '(') {
                    if ((c2=getc(fp)) == 'B') flag = 1;
                    else {  putchar(ESC); putchar(c); putchar('(');
                            ungetc(c2,fp); }
                }
                else if ((c2=='H') || (c2=='J')) flag = 0;
                else { putchar(ESC); putchar(c); ungetc(c2,fp); }
            }
            else if (c2 == 'H') flag = 0;
            else if (c2 == 'K') flag = 1;
            else { putchar(ESC); putchar(c); }
        }
        else if ((flag!=0) && (c>=0x21) && (c<=0x7e)) {
            c2 = getc(fp);
            if ((c2<=0x20) || (c2>=0x7f)) { putchar(c); ungetc(c2,fp); }
            else {
                if ((c%2) == 0) c2 = c2 + 0x7e;
                else c2 = c2 + 0x20;
                if (c2 <= 0x7f) c2 = c2 - 1;
                c = (c-0x21)/2 + 0x81;
                if (c >= 0xa0) c = c + 0x40;
                putchar(c); putchar(c2);
            }
        }
        else if ((c>=0xa1) && (c<=0xfe)) {
            c2 = getc(fp);
            if ((c2<=0xa0) || (c==0xff)) { putchar(c); ungetc(c2,fp); }
            else {
                if ((c%2) == 0) c2 = c2 - 0x02;
                else c2 = c2 - 0x60;
                if (c2 <= 0x7f) c2 = c2 - 1;
                c = (c-0xa1)/2 + 0x81;
                if (c >= 0xa0) c = c + 0x40;
                putchar(c); putchar(c2);
            }
        }
        else if (c == '\r') {
            c2 = getc(fp);
            if (c2 == '\n') { putchar('\r'); putchar('\n'); }
            else { putchar('\r'); ungetc(c2,fp); }
        }
        else if (c == '\n') { putchar('\r'); putchar('\n'); }
        else putchar(c);
    }
    if (fp != stdin) fclose(fp);
}
