/* psdivide.c */
#include    <stdio.h>
#define     SCL     "0.12"      /* = (72./DPI)  where DPI=600 */

main(int argc, char *argv[])
{   int i, j, isz, lwide, lhigh, wd, hi, kd, kend, npg=0;
    int wh[12] = { 558,792,1116,1584,2232,3168, 684,972,1368,1944,2736,3888 };
    char sht[4]="   ", buf[512];
    FILE *fp;
    fprintf(stderr, "psdivide: Divide large sheet PS into small ones PS\n");
    if (argc != 2)
        { fprintf(stderr, " Usage: psdivide <infile>\n"); exit(1); }
    if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, " file %s not found\n", argv[1]); exit(1); }
    if (fgets(buf,512,fp) == NULL)
        { fprintf(stderr, " input file empty\n"); exit(1); }
    if (strncmp(buf,"%!PS-Adobe",10) != 0)
        { fprintf(stderr, " input is not a PS file\n"); exit(1); }
    if (fgets(buf,512,fp) == NULL)
        { fprintf(stderr, " illegal EOF\n"); exit(1); }
    if (strncmp(buf,"%%Title: (",10) != 0)
        { fprintf(stderr, " header format rejected\n"); exit(1); }
    if (strncmp(&buf[13],") psplot ",9) != 0)
        { fprintf(stderr, " header format rejected\n"); exit(1); }
    strncpy(sht, &buf[10], 3);

    fprintf(stderr, "  Source PS size : %s\n", sht);
    if (((sht[0]!='A') && (sht[0]!='B')) ||
        ((sht[1] <'0') || (sht[1] >'4')) ||
        ((sht[2]!='P') && (sht[2]!='L')))
            { fprintf(stderr, " unkown sheet size\n"); exit(1); }
    i = '4' - sht[1]; if (sht[0] == 'B') i += 6;
    if (sht[2] == 'P') { lwide = wh[i]; lhigh = wh[i+1]; }
    else { lwide = wh[i+1]; lhigh = wh[i]; }
    isz = -1;
    while ((isz<0) || (isz>2)) {
        fprintf(stderr, "  Select size -- 0 (A4), 1 (B4) or 2 (A3) ==> "); 
        fgets(buf,80,stdin); sscanf(buf, "%d", &isz);
    }
    if (isz == 2)
        { wd = wh[1]; hi = wh[2]; sht[0] = 'A'; sht[1] = '3'; }
    else if (isz == 1)
        { wd = wh[6]; hi = wh[7]; sht[0] = 'B'; sht[1] = '4'; }
    else { wd = wh[0]; hi = wh[1]; sht[0] = 'A'; sht[1] = '4'; }
    if (((lwide-1)/wd+1)*((lhigh-1)/hi+1) > ((lwide-1)/hi+1)*((lhigh-1)/wd+1))
        { i = wd; wd = hi; hi = i; kd = 1; sht[2] = 'L'; }
    else { kd = 0; sht[2] = 'P'; }
    fprintf(stderr, "   going to use %s sheet\n", sht);

    printf("%%!PS-Adobe-3.0\n");
    printf("%%%%Title: (%s) psdivide\n", sht);
    while (1) {
        if (fgets(buf,512,fp) == NULL)
            { fprintf(stderr, " illegal EOF\n"); exit(1); }
        if (strncmp(buf,"%%Page:",7) == 0) break;
        fputs(buf, stdout);
    }

    for (i=0; i<lwide; i+=wd) for(j=0; j<lhigh; j+=hi) {
        rewind(fp); kend = 0;
        while (strncmp(fgets(buf,512,fp),"%%Page:",7) != 0);
        while (kend == 0) {
            npg++; printf("%%%%Page: %d %d\n", npg,npg);
            if (fgets(buf,512,fp) == NULL)
                { fprintf(stderr, " illegal EOF\n"); exit(1); }
            if (strncmp(buf,"gsave",5) != 0)
                { fprintf(stderr, " page format rejected\n"); exit(1); }
            if (kd == 0)
                printf("gsave %d %d translate", 20-i,25-j);
            else printf("gsave %d %d translate 90 rotate", 20+j+hi,25-i);
            printf(" %s %s scale 1 setlinecap 1 J\n", SCL, SCL);
            while (1) {
                if (fgets(buf,512,fp) == NULL)
                    { fprintf(stderr, " illegal EOF\n"); exit(1); }
                if (strcmp(buf,"grestore showpage\n") == 0) break;
                fputs(buf, stdout);
            }
            printf("grestore showpage\n\n");
            while (1) {
                if (fgets(buf,512,fp) == NULL)
                    { fprintf(stderr, " illegal EOF\n"); exit(1); }
                if (strncmp(buf,"%%Page:",7) == 0) break;
                if (strcmp(buf,"%%Trailer\n") == 0) { kend = 1; break; }
            }
        }
    }
    printf("%%%%Trailer\n");
    while (fgets(buf,512,fp) != NULL) {
        if (strncmp(buf,"%%Pages:",8) == 0) printf("%%%%Pages: %d\n", npg);
        else fputs(buf, stdout);
    }
    fclose(fp);
}
