/***********/
/* prtps.c */
/********************************************************/
/*  Usage:                                              */
/*         PRTPS  [-options] [infile [outfile]]         */
/*------------------------------------------------------*/
/*  infile  : filename of input data                    */
/*             if omitted, read from stdin stream       */
/*  outfile : PS output filename                        */
/*             if omitted, output to stdout stream      */
/*  options : [-lpi] [-P=[nps]] [-C=ncp] [-T] [-G]      */
/*    lpi:  line-spacing (3-8)  (default : 6 lpi)       */
/*    P  :  Specify page numbering (default : no numb.) */
/*       nps : start-page-number  (default : 1)         */
/*          (if 0, page numbering starts at 2nd sheet.) */
/*    C  :  Specify number of copies (default : 1 copy) */
/*       ncp : number of copies each page               */
/*    T  :  Specify 8-Cols TAB  (default : 4-Cols)      */
/*    G  :  Specify to start with bold Font       */
/*          (default : start with īnormal Font)    */
/********************************************************/
/*  Supported Escape Sequences                          */
/*    ESC  'O'  '1''0'  åɸ ե   */
/*    ESC  ':'  Filename  ' '  PageNumber  [CR]  LF     */
/*            PostScriptǡեɹ (ܲ)     */
/********************************************************/
#include <stdio.h>
#include <string.h>
#define ESC 0x1b
void prch(int cc, int c);
void htab(), nline(), epage(), tpage();
int xfpsf(FILE *fps, int npx);

int ppl=100, npg=-1, np=0, ncp=1, tabs=4, pbyte=EOF, nbyte;
int bold=1, font, fstr, ptloc, ptlin;
char bf[100];
FILE *fp1, *fp2, *fps;
main(int argc, char *argv[])
{   char *s, *kop, sop[17]="345678PpCcTtGg-,", fnm[100];
    int i, jop, ls, is, lpi, kin=0, kout=0;
    for (i=1; i<argc; i++) {
        s = argv[i];
        if (*s == '-') {
            jop = 0; ls = strlen(s);
            for (is=1,s++; is<ls; is++,s++) {
                if (jop == 0) {
                    if ((kop=strchr(sop,*s)) == NULL) {
                        fprintf(stderr, "unrecognized option  %s\n", argv[i]);
                        exit(1);
                    }
                    if (kop < (sop+6)) { lpi = *kop-'0'; ppl = 602/lpi; }
                    else if (kop < (sop+8)) { npg = 1; jop = 1; }
                    else if (kop < (sop+10)) { ncp = 1; jop = 4; }
                    else if (kop < (sop+12)) tabs = 8;
                    else if (kop < (sop+14)) bold = 2;
                }
                else if ((jop==1) || (jop==4)) {
                    if (*s == '=') { jop++; continue; }
                    else jop = 0;
                }
                else {
                    if ((*s<'0') || (*s>'9')) jop = 0;
                    else {
                        if (jop == 2) { npg = *s-'0'; jop = 3; }
                        else if (jop == 3) npg = npg*10 + (*s-'0');
                        else if (jop == 5) { ncp = *s-'0'; jop = 6; }
                        else ncp = ncp*10 + (*s-'0');
                    }
                }
            }
        }
        else if (kin == 0) kin = i;
        else if (kout == 0) kout = i;
        else { fprintf(stderr, "too many arguments\n"); exit(1); }
    }
    if (kin == 0) fp1=stdin;
    else if ((fp1=fopen(argv[kin],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[kin]); exit(1); }
    if (kout == 0) fp2=stdout;
    else if ((fp2=fopen(argv[kout],"w")) == NULL)
        { fprintf(stderr, "file %s open fail\n", argv[kout]); exit(1); }
    fprintf(stderr, "PRTPS 3.3e coded by nktk@gsj.go.jp\n");
    fprintf(fp2, "%%!PS-Adobe-3.0\n");
    fprintf(fp2, "%%%%Title: prtps 3.3e coded by nktk@gsj.go.jp\n");
    fprintf(fp2, "%%%%DocumentFonts: Courier Courier-Bold\n");
    fprintf(fp2, "%%%%+ Ryumin-Light-EUC-H Ryumin-Light-Ext-RKSJ-H\n");
    fprintf(fp2, "%%%%+ GothicBBB-Medium-EUC-H GothicBBB-Medium-Ext-RKSJ-H\n");
    fprintf(fp2, "%%%%Pages: (atend)\n");
    fprintf(fp2, "%%%%EndComments\n\n");
    fprintf(fp2, "%%%%BeginProlog\n");
    fprintf(fp2, "36 dict begin\n");
    fprintf(fp2, "/W /setlinewidth load def\n");
    fprintf(fp2, "/D /setdash load def\n");
    fprintf(fp2, "/T /setgray load def\n");
    fprintf(fp2, "/RGB /setrgbcolor load def\n");
    fprintf(fp2, "/S /stroke load def\n");
    fprintf(fp2, "/N /newpath load def\n");
    fprintf(fp2, "/M /moveto load def\n");
    fprintf(fp2, "/L /lineto load def\n");
    fprintf(fp2, "/J /setlinejoin load def\n");
    fprintf(fp2, "/C /closepath load def\n");
    fprintf(fp2, "/A /arc load def\n");
    fprintf(fp2, "/SH /show load def\n");
    fprintf(fp2, "/HMN { /Ryumin-Light-EUC-H findfont } bind def\n");
    fprintf(fp2, "/HGO { /GothicBBB-Medium-EUC-H findfont } bind def\n");
    fprintf(fp2, "/HMX { /Ryumin-Light-Ext-RKSJ-H findfont } bind def\n");
    fprintf(fp2, "/HGX { /GothicBBB-Medium-Ext-RKSJ-H findfont } bind def\n");
    fprintf(fp2, "/FCA { /Courier findfont } bind def\n");
    fprintf(fp2, "/FCB { /Courier-Bold findfont } bind def\n");
    fprintf(fp2, "/MN { HMN 90 scalefont setfont } bind def\n");  /* ī */
    fprintf(fp2, "/GO { HGO 90 scalefont setfont } bind def\n");  /*  */
    fprintf(fp2, "/MX { HMX 90 scalefont setfont } bind def\n");  /* ī */
    fprintf(fp2, "/GX { HGX 90 scalefont setfont } bind def\n");  /*  */
    fprintf(fp2, "/CA { FCA [75 0 0 100 0 0] makefont setfont } bind def\n");
    fprintf(fp2, "/CB { FCB [75 0 0 100 0 0] makefont setfont } bind def\n");
    fprintf(fp2, "/Count 0 def\n");
    fprintf(fp2, "/Byte 1 string def\n");
    fprintf(fp2, "/Color 3 string def\n");
    fprintf(fp2, "/Cmap 159 string def\n");
    fprintf(fp2, "/Pixels 768 string def\n");
    fprintf(fp2, "/Get1B {currentfile Byte readhexstring pop} bind def\n");
    fprintf(fp2, "/GetCol {currentfile Color readhexstring pop} bind def\n");
    fprintf(fp2, "/GrayPacket {/Count Get1B 0 get def Get1B pop\n");
    fprintf(fp2, "   0 1 Count {Pixels exch Byte putinterval} for\n");
    fprintf(fp2, "   Pixels 0 Count 1 add getinterval} bind def\n");
    fprintf(fp2, "/ColorPacket {/Count Get1B 0 get 3 mul def GetCol pop\n");
    fprintf(fp2, "   0 3 Count {Pixels exch Color putinterval} for\n");
    fprintf(fp2, "   Pixels 0 Count 3 add getinterval} bind def\n");
    fprintf(fp2, "/CmapPacket {/Count Get1B 0 get 3 mul def\n");
    fprintf(fp2, "   0 3 Count {Cmap exch GetCol putinterval} for} bind def\n");
    fprintf(fp2, "/CcodePacket {/Count Get1B 0 get 3 mul def  Color 0\n");
    fprintf(fp2, "   Cmap Get1B 0 get 3 mul 3 getinterval putinterval\n");
    fprintf(fp2, "   0 3 Count {Pixels exch Color putinterval} for\n");
    fprintf(fp2, "   Pixels 0 Count 3 add getinterval} bind def\n");
    fprintf(fp2, "/#copies %d def\n", ncp);
    fprintf(fp2, "%%%%EndProlog\n\n");
    while ((nbyte=getc(fp1)) != EOF) {
        if (pbyte == EOF) {
            pbyte = 0; tpage();
            if (nbyte == '\f') continue;
        }
        if (pbyte >= 0xa1) {
            if ((nbyte>=0xa1) && (nbyte<=0xfe))
                { prch(pbyte,nbyte); pbyte = 0; continue; }
            else { prch(0,pbyte); pbyte = 0; }
        }
        if (pbyte == 0) {
            if (nbyte == ESC) pbyte = ESC;
            else if ((nbyte<' ') || (nbyte==0x7f)) {
                if (nbyte == '\t') htab();
                else if (nbyte == '\n') nline();
                else if (nbyte == '\f') epage();
            }
            else if ((nbyte>=0xa1) && (nbyte<=0xfe)) pbyte = nbyte;
            else prch(0,nbyte);
        }
        else if (pbyte == ESC) {
            if (nbyte == 'O') pbyte = 'O';
            else if (nbyte == ':') {
                if (fstr > 0) { fprintf(fp2, ")SH\n"); fstr = 0; }
                fgets(bf,100,fp1); is = sscanf(bf,"%s%d",fnm,&i);
                if (is == 1) i = 1; else if (is < 1) fnm[0] = '\0';
                if ((fps=fopen(fnm,"r")) == NULL)
                    fprintf(stderr, "psfile %s not found\n", fnm);
                else {
                    fprintf(stderr, "Refering to psfile %s\n", fnm);
                    is = xfpsf(fps, i); fclose(fps);
                    if (is == 0) fprintf(stderr, "    successful.\n");
                    else if (is == -1) fprintf(stderr, "    abnormal EOF.\n");
                    else fprintf(stderr, "    error at line %d.\n", is);
                }
                nline(); pbyte = 0;
            }
            else { prch(0,nbyte); pbyte = 0; }
        }
        else if (pbyte == 'O') {
            if (nbyte == '0') { bold = 1; pbyte = 0; }
            else if (nbyte == '1') { bold = 2; pbyte = 0; }
            else { prch(0,'O'); prch(0,nbyte); pbyte = 0; }
        }
    }
    if (ferror(fp1)) fprintf(stderr, "Text File Read Error\n");
    if (pbyte >= 0xa1) prch(0,pbyte);
    if (pbyte != EOF) epage();
    fprintf(fp2, "%%%%Trailer\n");
    fprintf(fp2, "end\n");
    fprintf(fp2, "%%%%Pages: %d\n", np);
    fprintf(fp2, "%%%%EOF\n");
    if (fp2 != stdout) fclose(fp2);
    if (fp1 != stdin) fclose(fp1);
    fprintf(stderr, "  completed.\n");
}

int xfpsf(FILE *fps, int npx)
{   int n=0, ip;
    n++; if (fgets(bf,100,fps) == NULL) return(-1);
    if (strstr(bf,"%!PS-Adobe") != bf) return(n);
    n++; if (fgets(bf,100,fps) == NULL) return(-1);
    if (strstr(bf,"%%Title:") != bf) return(n);
    if (strstr(bf,"psplot") == NULL) return(n);
    while (1) {
        n++; if (fgets(bf,100,fps) == NULL) return(-1);
        if (strstr(bf,"%%Page:") == bf)
            if (sscanf(&bf[7],"%*d%d",&ip) == 1)
                if (ip == npx) break;
    }
    n++; if (fgets(bf,100,fps) == NULL) return(-1);
    if (strstr(bf,"gsave") != bf) return(n);
    while (1) {
        n++; if (fgets(bf,100,fps) == NULL) return(-1);
        if (strstr(bf,"showpage") != NULL) break;
        fputs(bf, fp2);
    }
    return(0);
}

void prch(int cc, int c)
{   if (ptloc > 79) { nline(); if (pbyte == EOF) tpage(); }
    if (cc == 0) {
        if ((fstr>0) && (fstr!=bold)) { fprintf(fp2, ")SH\n"); fstr = 0; }
        if (fstr == 0) {
            if (font == bold) { fputc('(',fp2); fstr = font; }
            else if (bold == 1) { fprintf(fp2, "CA("); fstr = font = 1; }
            else { fprintf(fp2, "CB("); fstr = font = 2; }
        }
    }
    else if ((cc>=0xa9) && (cc<=0xad)) {
        if ((ptloc==79) && (cc>=0xac)) { nline(); if (pbyte == EOF) tpage(); }
        if ((fstr>0) && (fstr!=(bold+4))) { fprintf(fp2, ")SH\n"); fstr = 0; }
        if (fstr == 0) {
            if (font == (bold+4)) { fputc('(',fp2); fstr = font; }
            else if (bold == 1) { fprintf(fp2, "MX("); fstr = font = 5; }
            else { fprintf(fp2, "GX("); fstr = font = 6; }
        }
        if ((cc%2) == 0) c -= 2; else { cc++; c -= 0x60; if (c < 80) c--; }
        cc = cc/2 + 0x30;
        fprintf(fp2, "\\%3o", cc); ptloc++;
    }
    else {
        if ((ptloc==79) && (c!=0)) { nline(); if (pbyte == EOF) tpage(); }
        if ((fstr>0) && (fstr!=(bold+2))) { fprintf(fp2, ")SH\n"); fstr = 0; }
        if (fstr == 0) {
            if (font == (bold+2)) { fputc('(',fp2); fstr = font; }
            else if (bold == 1) { fprintf(fp2, "MN("); fstr = font = 3; }
            else { fprintf(fp2, "GO("); fstr = font = 4; }
        }
        fprintf(fp2, "\\%3o", cc); ptloc++;
    }
    if (c != 0) {
        if (c >= 0x80) fprintf(fp2, "\\%3o", c);
        else if (c == '\\') fprintf(fp2, "\\\\");
        else if (c == '(') fprintf(fp2, "\\(");
        else if (c == ')') fprintf(fp2, "\\)");
        else fputc(c,fp2);
        ptloc++;
    }
}

void htab()
{   if (ptloc > 79) { nline(); if (pbyte == EOF) tpage(); }
    if (fstr == 0) {
        if (font == 0) { fprintf(fp2, "CA("); fstr = font = 1; }
        else { fputc('(',fp2); fstr = font; }
    }
    do { fputc(' ',fp2); ptloc++; } while ((ptloc%tabs) != 0);
}

void nline()
{   if (fstr > 0) { fprintf(fp2,")SH\n"); fstr = 0; }
    ptlin -= ppl;
    if (ptlin < 200) epage();
    else { fprintf(fp2,"600 %d M\n", ptlin); ptloc = 0; }
}

void epage()
{   if (fstr > 0) { fprintf(fp2,")SH\n"); fstr = 0; }
    fprintf(fp2, "grestore showpage\n\n"); pbyte = EOF;
    if (npg >= 0) npg++;
}

void tpage()
{   fprintf(fp2, "%%%%Page: %d %d\n", npg, ++np);
    fprintf(fp2, "gsave 20 25 translate 0.12 0.12 scale");
    fprintf(fp2, " 1 setlinecap 1 J\n"); font = fstr = 0;
    if (npg > 0) {
        if (npg < 10) fprintf(fp2, "4065 6350 M ");
        else if (npg < 100) fprintf(fp2, "4020 6350 M ");
        else fprintf(fp2, "3975 6350 M ");
        fprintf(fp2, "MX(-%d-)SH\n", npg);
    }
    fprintf(fp2,"600 6150 M\n"); ptlin = 6150; ptloc = 0; pbyte = 0;
}

