/* jisx.c -- EUC to JIS Code Conversion Filter */
#include <stdio.h>

main(int argc, char *argv[])
{   int c, c2, flag=0;
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while ((c=getc(fp)) != EOF) {
        if ((c<=0xa0) || (c==0xff)) {
            if (flag != 0)
                { putchar(0x1b); putchar('('); putchar('J'); flag = 0; }
            putchar(c);
        }
        else {
            c2 = getc(fp);
            if ((c2<=0xa0) || (c==0xff)) {
                if (flag != 0)
                    { putchar(0x1b); putchar('('); putchar('J'); flag = 0; }
                putchar(c); putchar(c2);
            }
            else {
                if (flag == 0)
                    { putchar(0x1b); putchar('$'); putchar('B'); flag = 1; }
                putchar(c & 0x7f); putchar(c2 & 0x7f);
            }
        }
    }
    if (flag != 0) { putchar(0x1b); putchar('('); putchar('J'); }
    if (fp != stdin) fclose(fp);
}
