/* jis.c -- Shift-JIS to JIS Code Conversion Filter */
#include <stdio.h>

main(int argc, char *argv[])
{   int c, c2, flag=0;
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while ((c=getc(fp)) != EOF) {
        if ((c<=0x80) || (c>=0xa0) && (c<=0xdf) || (c>=0xf0)) {
            if (flag != 0)
                { putchar(0x1b); putchar('('); putchar('J'); flag=0; }
            putchar(c);
        }
        else { c2 = getc(fp);
            if ((c2<=0x3f) || (c2==0x7f) || (c2>=0xfd)) {
                if (flag != 0)
                    { putchar(0x1b); putchar('('); putchar('J'); flag=0; }
                putchar(c); putchar(c2);
            }
            else {
                if (c > 0x9f) c = c - 0x40;
                c = (c-0x70) * 2;
                if (c2 < 0x80) c2 = c2 + 1;
                if (c2 < 0x9f) { c2 = c2 - 0x20; c = c - 1; }
                else c2 = c2 - 0x7e;
                if (flag == 0)
                    { putchar(0x1b); putchar('$'); putchar('B'); flag=1; }
                putchar(c); putchar(c2);
            }
        }
    }
    if (flag != 0) { putchar(0x1b); putchar('('); putchar('J'); }
    if (fp != stdin) fclose(fp);
}
