/* hexdump.c -- Filter for Hexadecimal Dump */
#include <stdio.h>

main(int argc, char *argv[])
{   int keof=0, k=0, n=0, i, j, c, c1, c2, m[16];
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"r")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while (1) {
        for (i=0; i<16; i++) {
            if ((m[i]=getc(fp)) == EOF) { keof=1; break; }
        }
        if (keof) break;
        printf("%03X0  ",n++);
        for (j=0; j<16; j++) {
            c = m[j];
            c1 = ((c>>4) | 0x30); if (c1 > 0x39) c1 = c1+7;
            c2 = ((c&15) | 0x30); if (c2 > 0x39) c2 = c2+7;
            putchar(c1); putchar(c2); putchar(' ');
            if ((j==7) || (j==15)) putchar(' ');
        }
        putchar('-');
        if (k == 0) j = 0;
        else { putchar('_'); j = 1; k = 0; }
        while (j < 16) {
            c1 = m[j++];
            if ((c1>=0xa0) && (c1<=0xfe)) {
                if (j == 16) {
                    if ((c2=getc(fp)) == EOF) { keof = 1; putchar('.'); }
                    else if ((c2>=0xa1) && (c2<=0xfe))
                        { ungetc(c2,fp); k = 1; putchar(c1); putchar(c2); }
                    else { ungetc(c2,fp); putchar('.'); }
                }
                else {
                    c2 = m[j++];
                    if ((c2>=0xa1) && (c2<=0xfe)) { putchar(c1); putchar(c2); }
                    else { j--; putchar('.'); }
                }
            }
            else if ((c1<0x20) || (c1>0x7e)) putchar('.');
            else putchar(c1);
        }
        putchar('-'); putchar('\n');
        if (keof) { i = 0; break; }
        if ((n%16) == 0) putchar('\n');
    }
    if (i > 0) {
        printf("%03X0  ",n);
        for (j=0; j<16; j++) {
            if (j < i) {
                c = m[j];
                c1 = ((c>>4) | 0x30); if (c1>0x39) c1 = c1+7;
                c2 = ((c&15) | 0x30); if (c2>0x39) c2 = c2+7;
                putchar(c1); putchar(c2); putchar(' ');
            }
            else { putchar(' '); putchar(' '); putchar(' '); }
            if((j==7) || (j==15)) putchar(' ');
        }
        putchar('-');
        if (k == 0) j = 0;
        else { putchar('_'); j = 1; k = 0; }
        while (j < 16) {
            if (j < i) c1 = m[j++]; else { c1 = ' '; j++; }
            if ((c1>=0xa0) && (c1<=0xfe)) {
                if (j == i) putchar('.');
                else {
                    c2 = m[j++];
                    if ((c2>=0xa1) && (c2<=0xfe)) { putchar(c1); putchar(c2); }
                    else { j--; putchar('.'); }
                }
            }
            else if ((c1<0x20) || (c1>0x7e)) putchar('.');
            else putchar(c1);
        }
        putchar('-'); putchar('\n');
    }
    if (fp != stdin) fclose(fp);
}
