/* cview.c --   Control-Codes Visualize Filter  */
/*  for UNIX  */
/*                                                                      */
/* 0x00(NUL) -> ^@   0x08(BS) -> ^H   0x10(DLE) -> ^P   0x18(CAN)-> ^X  */
/* 0x01(SOH) -> ^A   0x09(HT) -> ^I   0x11(DC1) -> ^Q   0x19(EM) -> ^Y  */
/* 0x02(STX) -> ^B   0x0A(LF) -> ^J   0x12(DC2) -> ^R   0x1A(SUB)-> ^Z  */
/* 0x03(ETX) -> ^C   0x0B(VT) -> ^K   0x13(DC3) -> ^S   0x1B(ESC)-> ^[  */
/* 0x04(EOT) -> ^D   0x0C(FF) -> ^L   0x14(DC4) -> ^T   0x1C(FS) -> ^\  */
/* 0x05(ENQ) -> ^E   0x0D(CR) -> ^M   0x15(NAK) -> ^U   0x1D(GS) -> ^]  */
/* 0x06(ACK) -> ^F   0x0E(SO) -> ^N   0x16(SYN) -> ^V   0x1E(RS) -> ^^  */
/* 0x07(BEL) -> ^G   0x0F(SI) -> ^O   0x17(ETB) -> ^W   0x1F(US) -> ^_  */
/*                                                                      */
/* 0x21( ! ) -> \!   0x5C( \ )-> \\   0x5E( ^ ) -> \^   0x7F(DEL)-> ^?  */
/*                                                                      */
/* 0x80 -> ^`   0x88 -> ^h   0x90 -> ^p   0x98 -> ^x   0xa0 -> ^$       */
/* 0x81 -> ^a   0x89 -> ^i   0x91 -> ^q   0x99 -> ^y                    */
/* 0x82 -> ^b   0x8A -> ^j   0x92 -> ^r   0x9A -> ^z   (0xA1-0xFE)      */
/* 0x83 -> ^c   0x8B -> ^k   0x93 -> ^s   0x9B -> ^{        ->          */
/* 0x84 -> ^d   0x8C -> ^l   0x94 -> ^t   0x9C -> ^|     ! (0x21-0x7E)  */
/* 0x85 -> ^e   0x8D -> ^m   0x95 -> ^u   0x9D -> ^}                    */
/* 0x86 -> ^f   0x8E -> ^n   0x96 -> ^v   0x9E -> ^~                    */
/* 0x87 -> ^g   0x8F -> ^o   0x97 -> ^w   0x9F -> ^#   0xFF -> ^/       */
/*                                                                      */
#include <stdio.h>

main(int argc, char *argv[])
{   int c, c2, k=0;
    FILE *fp;
    if (argc == 1) fp = stdin;
    else if ((fp=fopen(argv[1],"rb")) == NULL)
        { fprintf(stderr, "file %s not found\n", argv[1]); exit(1); }
    while ((c=getc(fp)) != EOF) {
        if ((c>=0xa1) && (c<=0xfe)) {
            c2 = getc(fp);
            if ((c2>=0xa1) && (c2<=0xfe)) {
                putchar(c); putchar(c2); k+=2;
                if (k > 75) { putchar('\n'); k = 0; }
                continue;
            }
            else {
                putchar('!'); putchar(c-0x80); k+=2;
                if (k > 75) { putchar('\n'); k = 0; }
                c = c2;
            }
        }
        if (c < 0x20) {
            putchar('^'); putchar(c+0x40); k+=2;
            if (c == '\n') { putchar('\n'); k = 0; }
        }
        else if (c <= 0x7e) {
            if ((c=='!') || (c=='\\') || (c=='^')) { putchar('\\'); k++; }
            putchar(c); k++;
        }
        else {
            putchar('^'); k+=2;
            if (c == 0x7f) putchar('?');
            else if (c == 0x9f) putchar('#');
            else if (c == 0xa0) putchar('$');
            else if (c == 0xff) putchar('/');
            else putchar(c-0x20);
        }
        if (k > 75) { putchar('\n'); k = 0; }
    }
    if (k > 0) putchar('\n');
    fclose(fp);
}
